import numpy
from model import *
from triangle import *
from setmask import *
from parameterize import *
from matdamageice import *
from paterson import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Square.exp',150000.)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelf.py')
md.materials=matdamageice()
md.materials.rheology_B=paterson(md.initialization.temperature)
md.materials.rheology_n=3.*numpy.ones((md.mesh.numberofelements,1))
md.materials.rheology_Z=0.5*numpy.ones((md.mesh.numberofvertices,1))
md=setflowequation(md,'macayeal','all')
md.cluster=generic('name',oshostname(),'np',3)
md=solve(md,DiagnosticSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Vx','Vy','Vel','Pressure']
field_tolerances=[1e-13,1e-13,1e-13,1e-13]
field_values=[\
	md.results['DiagnosticSolution'][1]['Vx'],\
	md.results['DiagnosticSolution'][1]['Vy'],\
	md.results['DiagnosticSolution'][1]['Vel'],\
	md.results['DiagnosticSolution'][1]['Pressure'],\
	]
