/*! \file Vertex.h 
 *  \brief: header file for vertex object
 */

#ifndef _VERTEX_H_
#define _VERTEX_H_

/*Headers:*/
/*{{{*/
#include "../classes.h"
class IoModel;
template <class doubletype> class Vector;
class Parameters;
#include "../../shared/Exceptions/exceptions.h"
#include "../../toolkits/toolkits.h"
#include "../../include/include.h"

/*}}}*/

class Vertex: public Object{

	public: 
		bool       clone;
		int        id;           // random index
		int        sid;          // "serial" id (rank of this vertex if the dataset was on 1 cpu)
		int        pid;          // "parallel" id
		IssmDouble x;
		IssmDouble y;
		IssmDouble z;
		IssmDouble sigma;        //sigma coordinate: (z-bed)/thickness
		int        connectivity; //number of vertices connected to this vertex

		/*Vertex constructors, destructors {{{*/
		Vertex();
		Vertex(int id, int sid,IssmDouble x, IssmDouble y, IssmDouble z, IssmDouble sigma, int connectivity); 
		void Init(int id, int sid, IssmDouble x, IssmDouble y, IssmDouble z, IssmDouble sigma,int connectivity);
		Vertex(int id, int sid, int i, IoModel* iomodel);
		~Vertex();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*Vertex management:*/ 
		int   Sid(void); 
		int   Connectivity(void); 
		void  UpdatePosition(Vector<IssmDouble>* vz,Parameters* parameters,IssmDouble* thickness,IssmDouble* bed);
		void  DistributePids(int* ppidcount);
		void  OffsetPids(int pidcount);
		void  ShowTruePids(int* borderpids);
		void  UpdateClonePids(int* allborderpids);
		void  SetClone(int* minranks);
};
#endif  /* _VERTEX_H */
