/*!\file:  ElementVector.h
 * \brief container for information needed to plug element vector generated by elements 
 * into the pf global load vector. 
 * This object will hold the element vector on the g-set, the local as well as global 
 * dof lists in the f set
 */ 

#ifndef _ELEMENT_VECTOR_H_
#define _ELEMENT_VECTOR_H_

/*Headers:*/
/*{{{*/
#include "../objects/Object.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
class Node;
template <class doubletype> class Vector;
class Parameters;
/*}}}*/

class ElementVector{

	public:

		int      nrows;
		IssmDouble*  values;

		//gset
		int*     gglobaldoflist;

		//fset
		int      fsize;
		int*     flocaldoflist;
		int*     fglobaldoflist;

		/*ElementVector constructors, destructors {{{*/
		ElementVector();
		ElementVector(ElementVector* pe1,ElementVector* pe2);
		ElementVector(ElementVector* pe1,ElementVector* pe2,ElementVector* pe3);
		ElementVector(Node** nodes,int numnodes,Parameters* parameters,int approximation=NoneApproximationEnum);
		~ElementVector();
		/*}}}*/
		/*ElementVector specific routines {{{*/
		void AddToGlobal(Vector<IssmDouble>* pf);
		void InsertIntoGlobal(Vector<IssmDouble>* pf);
		void Echo(void);
		void CheckConsistency(void);
		void Init(ElementVector* pe);
		void SetValue(IssmDouble scalar);
		/*}}}*/
};
#endif //#ifndef _ELEMENT_VECTOR_H_
