/*
 * FemModel.h: 
 */

#ifndef _FEMMODEL_H_
#define _FEMMODEL_H_

/*Headers:*/
/*{{{*/
#include "./objects/Object.h"
#include "../toolkits/toolkits.h"
class DataSet;
class Parameters;
class NodeSets;
class Nodes;
class Vertices;
class Results;
class Constraints;
class Loads;
class Materials;
class Profiler;
/*}}}*/

class FemModel {

	/*no private members, as we need access to these datasets quite often!:*/

	public:

		int          nummodels;
		int          solution_type;
		int         *analysis_type_list;   //list of analyses this femmodel is going to carry out
		int          analysis_counter;     //counter into analysis_type_list

		Profiler*    profiler;             //keep time, cpu and mem statistics while we are running.

		Elements    *elements;             //elements (one set for all analyses)
		Nodes       *nodes;                //one set of nodes
		Vertices    *vertices;             //one set of vertices
		Constraints *constraints;          //one set of constraints. each constraint knows which analysis_type it handles
		Loads       *loads;                //one set of constraints. each constraint knows which analysis_type it handles
		Materials   *materials;            //one set of materials, for each element
		Parameters  *parameters;           //one set of parameters, independent of the analysis_type
		Results     *results;              //results that cannot be fit into the elements 
		COMM        comm;                  //communicator for this particular model

		/*constructors, destructors: */
		FemModel(int argc,char** argv,COMM comm_init);
		FemModel(char* rootpath, char* inputfilename, char* outputfilename, char* petscfilename, char* lockfilename, const int solution_type,const int* analyses,const int nummodels);
		~FemModel();
		void InitFromFiles(char* rootpath, char* inputfilename, char* outputfilename, char* petscfilename, char* lockfilename, const int solution_type,const int* analyses,const int nummodels);

		/*Methods: */
		void Echo();
		void Solve(void);
		void OutputResults(void);
		void SetStaticComm();
		void PrintBanner(void);

		/*Fem: */
		void  SetCurrentConfiguration(int configuration_type);
		void  SetCurrentConfiguration(int configuration_type,int analysis_type);

};

#endif
