/*!\file: Options.h
 * \brief prototypes for Options.h
 */ 

#ifndef _CONTAINER_OPTIONS_H_
#define _CONTAINER_OPTIONS_H_

#include "../classes/objects/Options/GenericOption.h"

/*forward declarations */
class Option;

class Options: public DataSet{

	public:

		/*constructors, destructors*/
		Options();
		~Options();

		/*numerics*/
		int  AddOption(Option* in_oobject);
		Option* GetOption(const char* name);

		template <class OptionType> void Get(OptionType* pvalue,const char* name){ /*{{{*/

			vector<Object*>::iterator object;
			GenericOption<OptionType>* genericoption=NULL;

			/*Get option*/
			genericoption=(GenericOption<OptionType>*)GetOption(name);

			/*If the pointer is not NULL, the option has been found*/
			if(genericoption){
				genericoption->Get(pvalue);
			}
			/*Else, the Option does not exist, no default provided*/
			else{
				_error_("option of name \"" << name << "\" not found, and no default value has been provided");
			}
		}
		/*}}}*/
		template <class OptionType> void Get(OptionType* pvalue,int* pnumel, const char* name){ /*{{{*/

			vector<Object*>::iterator object;
			GenericOption<OptionType>* genericoption=NULL;

			/*Get option*/
			genericoption=(GenericOption<OptionType>*)GetOption(name);

			/*If the pointer is not NULL, the option has been found*/
			if(genericoption){
				genericoption->Get(pvalue);
				*pnumel=genericoption->NumEl();
			}
			/*Else, the Option does not exist, no default provided*/
			else{
				_error_("option of name \"" << name << "\" not found, and no default value has been provided");
			}
		}
		/*}}}*/
		template <class OptionType> void Get(OptionType* pvalue,const char* name,OptionType default_value){ /*{{{*/

			vector<Object*>::iterator object;
			GenericOption<OptionType>* genericoption=NULL;

			/*Get option*/
			genericoption=(GenericOption<OptionType>*)GetOption(name);

			/*If the pointer is not NULL, the option has been found*/
			if(genericoption){
				genericoption->Get(pvalue);
			}
			else{
				*pvalue=default_value;
			}
		}
		/*}}}*/
		template <class OptionType> void Get(OptionType* pvalue,int* pnumel, const char* name,OptionType default_value){ /*{{{*/

			vector<Object*>::iterator object;
			GenericOption<OptionType>* genericoption=NULL;

			/*Get option*/
			genericoption=(GenericOption<OptionType>*)GetOption(name);

			/*If the pointer is not NULL, the option has been found*/
			if(genericoption){
				genericoption->Get(pvalue);
				*pnumel=genericoption->NumEl();
			}
			else{
				*pvalue=default_value;
			}
		}
		/*}}}*/

};

#endif //ifndef _INPUTS_H_

template <> inline void Options::Get(char** pvalue,const char* name,char* default_value){ /*{{{*/

	vector<Object*>::iterator object;
	GenericOption<char*>* genericoption=NULL;

	/*Get option*/
	genericoption=(GenericOption<char*>*)GetOption(name);

	/*If the pointer is not NULL, the option has been found*/
	if(genericoption){
		genericoption->Get(pvalue);
	}
	else{
		/*Make a copy*/
		char* outstring=NULL;
		int   stringsize;

		stringsize=strlen(default_value)+1;
		outstring=xNew<char>(stringsize);
		xMemCpy<char>(outstring,default_value,stringsize);
		*pvalue=outstring;
	}
}
/*}}}*/
