/*!\file:  AssociateSegmentToElement.cpp
 * \brief for each segment, look for the corresponding element.
 */ 

#include "./trimesh.h"

int AssociateSegmentToElement(double** psegments,int nseg, double* index,int nel){

	/*Error management: */
	int i;
	int noerr=1;

	/*Input: */
	double* segments=NULL;

	/*node indices: */
	double A,B;

	/*Recover segments: */
	segments=*psegments;

	for (i=0;i<nseg;i++){
		A=*(segments+3*i+0);
		B=*(segments+3*i+1);
		*(segments+3*i+2)=FindElement(A,B,index,nel)+1; //matlab indexing.
	}

	/*Assign output pointers: */
	*psegments=segments;
	return noerr;
}
