/* \file Exceptions.cpp
 * \brief: implementation of the exceptions.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../shared.h"
#include "../../include/include.h"

ErrorException::ErrorException(const string &what_arg){

	what_str=what_arg;
	file_name="";
	function_name="";
	file_line=0;
}

ErrorException::ErrorException(const string& what_file, const string& what_function,int what_line, const string& what_arg){

	what_str=what_arg;
	file_name=what_file;
	function_name=what_function;
	file_line=what_line;
}

ErrorException::~ErrorException() throw(){

	int num_procs;

	/*recover num_procs:*/
	num_procs=IssmComm::GetSize();

	/*We want the report only for matlab modules, otherwise we get twice the report
	 * We assume that if num_procs==1, it is a module (FIXME)*/
	if(num_procs==1) this->Report();
}

const char* ErrorException::what() const throw(){
	return what_str.c_str();
}

void ErrorException::Report() const{

	int my_rank;
	int num_procs;

	/*recover my_rank and num_procs:*/
	my_rank=IssmComm::GetRank();
	num_procs=IssmComm::GetSize();

	if (function_name=="" || file_line==0){ //WINDOWS
		_printString_("Error message: " << what());
	}
	else{
		if(num_procs==1){
			_printLine_("\n??? Error using ==> " << file_name.c_str() << ":" << file_line);
			_printLine_(function_name.c_str() << " error message: " << what() << "\n");
		}
		else{
			_printLine_("\n[" << my_rank<< "] ??? Error using ==> " << file_name.c_str() << ":" << file_line);
			_printLine_("[" << my_rank << "] " << function_name.c_str() << " error message: " << what() << "\n");
		}
	}
	return;
}
