/*
 * CreateConstraintsThermal.c:
 */

#include "../../../Container/Container.h"
#include "../../../modules/modules.h"
#include "../../../io/io.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsThermal(Constraints** pconstraints, IoModel* iomodel){

	/*Intermediary*/
	int i;
	int count;
	int    dim;

	/*Output*/
	Constraints* constraints = NULL;

	/*Fetch parameters: */
	iomodel->Constant(&dim,MeshDimensionEnum);

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints();

	/*Only 3d mesh supported*/
	if (dim==3){
		IoModelToConstraintsx(constraints,iomodel,ThermalSpctemperatureEnum,ThermalAnalysisEnum);
	}

	/*Assign output pointer: */
	*pconstraints=constraints;
}
