/*!\file MinVxx
 */

#include "./MinVxx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void MinVxx( IssmDouble* pminvx, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters,bool process_units){

	int i;
	IssmDouble minvx;
	IssmDouble node_minvx;
	IssmDouble element_minvx;

	/*Go through elements, and request velocity: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->MinVx(&element_minvx,process_units); //go pick up the minimum velocity in the inputs

		if(i==0)minvx=element_minvx; //initialize minvx
		else{
			if(element_minvx<minvx)minvx=element_minvx;
		}
	}
	/*A safeguard in case: */
	if(elements->Size()==0){
		minvx=INFINITY;
	}

	/*Figure out minimum across the cluster: */
	#ifdef _HAVE_MPI_
	MPI_Reduce (&minvx,&node_minvx,1,MPI_DOUBLE,MPI_MIN,0,IssmComm::GetComm() );
	MPI_Bcast(&node_minvx,1,MPI_DOUBLE,0,IssmComm::GetComm());   
	minvx=node_minvx;
	#endif

	/*Assign output pointers:*/
	*pminvx=minvx;
}
