/*!\file MaxVyx
*/

#include "./MaxVyx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void MaxVyx( IssmDouble* pmaxvy, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters,bool process_units){

	int i;
	IssmDouble maxvy;
	IssmDouble node_maxvy;
	IssmDouble element_maxvy;

	/*Go through elements, and request velocity: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->MaxVy(&element_maxvy,process_units); //go pick up the minimum velocity in the inputs

		if(i==0)maxvy=element_maxvy; //initialize maxvy
		else{
			if(element_maxvy>maxvy)maxvy=element_maxvy;
		}
	}
	/*A safeguard in case: */
	if(elements->Size()==0){
		maxvy=-INFINITY;
	}

	/*Figure out minimum across the cluster: */
	#ifdef _HAVE_MPI_
	MPI_Reduce (&maxvy,&node_maxvy,1,MPI_DOUBLE,MPI_MAX,0,IssmComm::GetComm() );
	MPI_Bcast(&node_maxvy,1,MPI_DOUBLE,0,IssmComm::GetComm());   
	maxvy=node_maxvy;
	#endif

	/*Assign output pointers:*/
	*pmaxvy=maxvy;
}
