/*!\file MaxVelx
 * \brief: compute misfit between observations and model
 */

#include "./MaxVelx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void MaxVelx( IssmDouble* pmaxvel, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters,bool process_units){

	int i;
	IssmDouble maxvel;
	IssmDouble node_maxvel;
	IssmDouble element_maxvel;

	/*Go through elements, and request velocity: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->MaxVel(&element_maxvel,process_units); //go pick up the maximum velocity in the inputs

		if(i==0)maxvel=element_maxvel; //initialize maxvel
		else{
			if(element_maxvel>maxvel)maxvel=element_maxvel;
		}
	}
	/*A safeguard in case: */
	if(elements->Size()==0){
		maxvel=-INFINITY;
	}

	/*Figure out maximum across the cluster: */
	#ifdef _HAVE_MPI_
	MPI_Reduce (&maxvel,&node_maxvel,1,MPI_DOUBLE,MPI_MAX,0,IssmComm::GetComm() );
	MPI_Bcast(&node_maxvel,1,MPI_DOUBLE,0,IssmComm::GetComm());   
	maxvel=node_maxvel;
	#endif

	/*Assign output pointers:*/
	*pmaxvel=maxvel;
}
