/*!\file:  AverageFilterx.cpp
 * \brief  plug missing values of a double* array, using interpolation techniques. This 
 * is an adaptation of Dr. Crippen's routine (Jet Propulsion Lab, see AverageFilterCrippen.c
 * for more details.
 */ 

#include <stdio.h>
#include <time.h>
#include "./AverageFilterx.h"
#include "../../shared/shared.h"

int AverageFilterx(double** pimageout,double* image, int lines,int samps,int smooth){

	double      temp;
	int         numvalues;
	long			i, j;
	int         pix1, pix2;

	/*output: */
	double* imageout=NULL;

	imageout=xNew<double>(samps*lines);

  	for ( i = 0; i < lines; i++ ){
  		for ( j = 0; j < samps; j++ ){
			temp=0;
			numvalues=0;
			for ( pix1 = -smooth; pix1 < smooth+1; pix1++ ){
				for ( pix2 = -smooth; pix2 < smooth+1; pix2++ ){
					if( i+pix1 < 0 || i+pix1 > lines-1 || j+pix2 < 0 || j+pix2 > samps-1) continue;
					numvalues=numvalues+1;
					temp=temp+*(image+samps*(i+pix1)+j+pix2);
				}
			}
			*(imageout+samps*(i)+j)=temp/numvalues;
		}
	}

	/*Assign output pointers: */
	*pimageout=imageout;

	return 1;
}
