/*!\file VectorParam.c
 * \brief: implementation of the VectorParam object
 */

/*header files: */
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../shared/shared.h"
#include "../../../Container/Container.h"
#include "../../../include/include.h"
/*}}}*/

/*VectorParam constructors and destructor*/
/*FUNCTION VectorParam::VectorParam(){{{*/
VectorParam::VectorParam(){
	return;
}
/*}}}*/
/*FUNCTION VectorParam::VectorParam(int enum_type,IssmVector value){{{*/
VectorParam::VectorParam(int in_enum_type,Vector<IssmDouble>* in_value){

	enum_type=in_enum_type;

	value=NULL;

	if(in_value){
		value=in_value->Duplicate();
		in_value->Copy(value);
	}
}
/*}}}*/
/*FUNCTION VectorParam::~VectorParam(){{{*/
VectorParam::~VectorParam(){
	xdelete(&value);
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION VectorParam::Echo {{{*/
void VectorParam::Echo(void){

	_printLine_("VectorParam:");
	_printLine_("   enum: " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");

}
/*}}}*/
/*FUNCTION VectorParam::DeepEcho{{{*/
void VectorParam::DeepEcho(void){

	int i;
	_printLine_("VectorParam:");
	_printLine_("   enum: " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	value->Echo();
}
/*}}}*/
/*FUNCTION VectorParam::Id{{{*/
int    VectorParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION VectorParam::ObjectEnum{{{*/
int VectorParam::ObjectEnum(void){

	return VectorParamEnum;

}
/*}}}*/
/*FUNCTION VectorParam::copy{{{*/
Object* VectorParam::copy() {

	return new VectorParam(this->enum_type,this->value);

}
/*}}}*/

/*VectorParam virtual functions definitions: */
/*FUNCTION VectorParam::GetParameterValue{{{*/
void  VectorParam::GetParameterValue(Vector<IssmDouble>** poutput){
	Vector<IssmDouble>*  output=NULL;

	if(value){
		output=value->Duplicate();
		value->Copy(output);
	}
	*poutput=output;
}
/*}}}*/
/*FUNCTION VectorParam::GetParameterName{{{*/
void VectorParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION VectorParam::SetValue{{{*/
void  VectorParam::SetValue(Vector<IssmDouble>* vector){

	/*avoid leak: */
	xdelete(&value);

	/*copy: */
	value=vector->Duplicate();
	vector->Copy(value);
}
/*}}}*/
/*FUNCTION VectorParam::UnitConversion{{{*/
void  VectorParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
