/*!\file MaxAbsVxx
 */

#include "./MaxAbsVxx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void MaxAbsVxx( IssmDouble* pmaxabsvx, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters,bool process_units){

	int i;
	IssmDouble maxabsvx;
	IssmDouble node_maxabsvx;
	IssmDouble element_maxabsvx;

	/*Go through elements, and request velocity: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->MaxAbsVx(&element_maxabsvx,process_units); //go pick up the maximum velocity in the inputs

		if(i==0)maxabsvx=element_maxabsvx; //initialize maxabsvx
		else{
			if(element_maxabsvx>maxabsvx)maxabsvx=element_maxabsvx;
		}
	}
	/*A safeguard in case: */
	if(elements->Size()==0){
		maxabsvx=-INFINITY;
	}

	/*Figure out maximum across the cluster: */
	#ifdef _HAVE_MPI_
	MPI_Reduce (&maxabsvx,&node_maxabsvx,1,MPI_DOUBLE,MPI_MAX,0,IssmComm::GetComm() );
	MPI_Bcast(&node_maxabsvx,1,MPI_DOUBLE,0,IssmComm::GetComm());   
	maxabsvx=node_maxabsvx;
	#endif

	/*Assign output pointers:*/
	*pmaxabsvx=maxabsvx;
}
