/*!\file CostFunctionx
 * \brief: compute misfit between observations and model
 */

#include "./CostFunctionx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../Responsex/Responsex.h"

void CostFunctionx(IssmDouble* pJ, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters){

	/*Intermediary*/
	int      i;
	int      num_responses;
	Element *element       = NULL;
	int     *responses     = NULL;

	/*output: */
	IssmDouble J,Jplus;

	/*Recover parameters*/
	parameters->FindParam(&num_responses,InversionNumCostFunctionsEnum);
	parameters->FindParam(&responses,NULL,NULL,StepResponsesEnum);

	/*Get response*/
	J=0;
	for(int i=0;i<num_responses;i++){
		Responsex(&Jplus,elements,nodes,vertices,loads,materials,parameters,EnumToStringx(responses[i]),false,i); //False means DO NOT process units
		J+=Jplus;
	}

	/*Assign output pointers: */
	xDelete<int>(responses);
	*pJ=J;
}
