/*!\file:  EnvironmentFinalize.cpp
 * \brief: finalize Petsc, MPI, you name it
 */ 
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
#include "../include/include.h"
#include "../toolkits/toolkits.h"
#include "../shared/shared.h"

void EnvironmentFinalize(void){

	#ifdef _HAVE_PETSC_
	_pprintLine_("closing MPI and Petsc");
	PetscFinalize(); 
	#else
	#ifdef _HAVE_MPI_
	_pprintLine_("closing MPI");
	MPI_Finalize();
	#endif
	#endif
}
