/*! \file IssmComm.cpp
 * \brief  file containing the methods for IssmComm.h
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./IssmComm.h"

void IssmComm::SetComm(COMM incomm){ /*{{{*/
	comm=incomm;
}/*}}}*/
COMM IssmComm::GetComm(){  /*{{{*/
	return comm;
}/*}}}*/
int IssmComm::GetRank(){  /*{{{*/
	int my_rank2;
	#ifdef _HAVE_MPI_
	MPI_Comm_rank(comm,&my_rank2);
	#else
	my_rank2=0;
	#endif
	return my_rank2;

}/*}}}*/
int IssmComm::GetSize(){  /*{{{*/
	int size;
	#ifdef _HAVE_MPI_
	MPI_Comm_size(comm,&size);
	#else
	size=1;
	#endif
	return size;

}/*}}}*/
