/* \file DetermineLocalSize.cpp
 * \brief: routine to determine local size of a global petsc matrix or vector. 
 */

#include <stdio.h>
#include <math.h>
#include "../../../shared/shared.h"
#include "../../../include/types.h"

int DetermineLocalSize(int global_size,COMM comm){

	/*output: */
	int  local_size;

	/*intermediary: */
	int  i;
	int  row_rest;
	int* num_local_rows=NULL;

	/*from MPI: */
	int num_procs2;
	int my_rank2;

	/*recover my_rank2*/
	MPI_Comm_rank(comm,&my_rank2);
	MPI_Comm_size(comm,&num_procs2);

	
	/*We are  not bound by any library, just use what seems most logical*/
	num_local_rows=xNew<int>(num_procs2);    

	for (i=0;i<num_procs2;i++){
		/*Here, we use floor. We under distribute rows. The rows 
		  left  are then redistributed, therefore resulting in a 
		  more even distribution.*/
		num_local_rows[i]=(int)floor((double)global_size/(double)num_procs2); 
	}
	
	/*There may be some rows left. Distribute evenly.*/ 
	row_rest=global_size - num_procs2*(int)floor((double)global_size/(double)num_procs2);
	for (i=0;i<row_rest;i++){
		num_local_rows[i]++;
	}
	local_size=num_local_rows[my_rank2];
	
	/*free ressources: */
	xDelete<int>(num_local_rows);

	/*return size: */
	return local_size;

}
