/*!\file NewVec.cpp
 * \brief: create distributed Petsc vector.
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*Petsc includes: */
#include "petscmat.h"
#include "petscvec.h"
#include "petscksp.h"

#include "./petscpatches.h"
#include "../../mpi/patches/mpipatches.h"

Vec NewVec(int size,COMM comm,bool fromlocalsize){

	int ierr;
	int local_size;

	/*output: */
	Vec vector=NULL;

	/*determine local size of vector: */
	if(fromlocalsize){
		local_size=size;
	}
	else{
		local_size=DetermineLocalSize(size);
	}
	
	VecCreate(comm,&vector); 
	
	VecSetSizes(vector,local_size,PETSC_DECIDE); 
	VecSetFromOptions(vector); 

	/*fill with 0: */
	VecSet(vector,0.0);

	return vector;
}
