/*\file petscpatches.h
 * \brief: our own patches for petsc use
 */

#ifndef _PETSC_PATCHES_H_
#define _PETSC_PATCHES_H_

#include "petscmat.h"
#include "petscvec.h"
#include "petscksp.h"
#include "petscsys.h"

#include "./SolverEnum.h"
#include "../../toolkitsenums.h"
#include "../../../include/types.h"

class Parameters;

Vec NewVec(int size,bool fromlocalsize=false);
Mat NewMat(int M,int N,COMM comm);
Mat NewMat(int M,int N,double sparsity,COMM comm);
Mat NewMat(int M,int N,int connectivity,int numberofdofspernode, COMM comm);

int VecTranspose(Vec* tvector,Vec vector);
int VecToMPISerial(double** pgathered_vector, Vec vector,COMM comm);
void GetOwnershipBoundariesFromRange(int* plower_row,int* pupper_row,int range,COMM comm);
void MatFree(Mat* pmat);
void ISFree(IS* pis);
void VecFree(Vec* pvec);
void KSPFree(KSP* pksp);
void VecPartition(Vec* poutvector,Vec vectorA, double* row_partition_vector, int row_partition_vector_size,bool kffpartitioning);
int MatPartition(Mat* poutmatrix,Mat matrixA,double* row_partition_vector,int row_partition_vector_size ,
		double* col_partition_vector,int col_partition_vector_size);
void MatInvert(Mat* pInv, Mat Matrix);
void PetscOptionsInsertMultipleString(char* options_string);
void PetscOptionsDetermineSolverType(int* psolver_type);
void VecMerge(Vec A, Vec B, double* row_partition_vector,int row_partition_size);
void MatMultPatch(Mat A,Vec X, Vec AX,COMM comm);
void MatToSerial(double** poutmatrix,Mat matrix,COMM comm);
void VecDuplicatePatch(Vec* output, Vec input);
Vec  SerialToVec(double* vector,int vector_size);
InsertMode ISSMToPetscInsertMode(InsMode mode);
NormType ISSMToPetscNormMode(NormMode mode);
MatType ISSMToPetscMatrixType(MatrixType type);

void PetscMatrixToDoubleMatrix(double** pmatrix, int* prows, int* pcols,Mat matrix);
void PetscVectorToDoubleVector(double** pvector, int* prows, Vec vector);

#endif
