/*!\file MaxVxx
 */

#include "./MaxVxx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void MaxVxx( IssmDouble* pmaxvx, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters,bool process_units){
	
	int i;
	IssmDouble maxvx;
	IssmDouble node_maxvx;
	IssmDouble element_maxvx;

	/*Go through elements, and request velocity: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->MaxVx(&element_maxvx,process_units); //go pick up the minimum velocity in the inputs
	
		if(i==0)maxvx=element_maxvx; //initialize maxvx
		else{
			if(element_maxvx>maxvx)maxvx=element_maxvx;
		}
	}
	/*A safeguard in case: */
	if(elements->Size()==0){
		maxvx=-INFINITY;
	}

	/*Figure out minimum across the cluster: */
	#ifdef _HAVE_MPI_
	MPI_Reduce (&maxvx,&node_maxvx,1,MPI_DOUBLE,MPI_MAX,0,IssmComm::GetComm() );
	MPI_Bcast(&node_maxvx,1,MPI_DOUBLE,0,IssmComm::GetComm());   
	maxvx=node_maxvx;
	#endif

	/*Assign output pointers:*/
	*pmaxvx=maxvx;
}
