/*!\file IceVolumex
 * \brief: compute total ice volume
 */

#include "./IceVolumex.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void IceVolumex(IssmDouble* pV, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters,bool process_units){

	IssmDouble local_ice_volume = 0;
	IssmDouble total_ice_volume;

	for(int i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		local_ice_volume+=element->IceVolume();
	}
	#ifdef _HAVE_MPI_
	MPI_Reduce(&local_ice_volume,&total_ice_volume,1,MPI_DOUBLE,MPI_SUM,0,IssmComm::GetComm() );
	MPI_Bcast(&total_ice_volume,1,MPI_DOUBLE,0,IssmComm::GetComm());
	#else
	total_ice_volume=local_ice_volume;
	#endif

	/*Assign output pointers: */
	*pV=total_ice_volume;
}
