/*!\file TotalSmbx
 * \brief: compute total ice sheet surface mass balance 
 */

#include "./TotalSmbx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void TotalSmbx(IssmDouble* pSmb, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters,bool process_units){

	IssmDouble local_smb = 0;
	IssmDouble total_smb;

	for(int i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		local_smb+=element->TotalSmb();
	}
	#ifdef _HAVE_MPI_
	MPI_Reduce(&local_smb,&total_smb,1,MPI_DOUBLE,MPI_SUM,0,IssmComm::GetComm() );
	MPI_Bcast(&total_smb,1,MPI_DOUBLE,0,IssmComm::GetComm());
	#else
	total_smb=local_smb;
	#endif

	/*Assign output pointers: */
	*pSmb=total_smb;
}
