/*!\file MaxAbsVyx
 */

#include "./MaxAbsVyx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void MaxAbsVyx( IssmDouble* pmaxabsvy, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters,bool process_units){
	
	int i;
	IssmDouble maxabsvy;
	IssmDouble node_maxabsvy;
	IssmDouble element_maxabsvy;


	/*Go through elements, and request velocity: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->MaxAbsVy(&element_maxabsvy,process_units); //go pick up the maximum velocity in the inputs
	
		if(i==0)maxabsvy=element_maxabsvy; //initialize maxabsvy
		else{
			if(element_maxabsvy>maxabsvy)maxabsvy=element_maxabsvy;
		}
	}
	/*A safeguard in case: */
	if(elements->Size()==0){
		maxabsvy=-INFINITY;
	}

	/*Figure out maximum across the cluster: */
	#ifdef _HAVE_MPI_
	MPI_Reduce (&maxabsvy,&node_maxabsvy,1,MPI_DOUBLE,MPI_MAX,0,IssmComm::GetComm() );
	MPI_Bcast(&node_maxabsvy,1,MPI_DOUBLE,0,IssmComm::GetComm());   
	maxabsvy=node_maxabsvy;
	#endif

	/*Assign output pointers:*/
	*pmaxabsvy=maxabsvy;
}
