/* \file classes.h
 * \brief: prototype header for all classes used in ISSM.
 */

#ifndef ALL_CLASSES_H_
#define ALL_CLASSES_H_

/*Objects derived classes, which are used in our containers: */
#include "./objects/objects.h"

/*matrix: */
#include "./matrix/matrixobjects.h"

/*bamg: */
#include "./bamg/bamgobjects.h"

/*gauss: */
#include "./gauss/gaussobjects.h"

/*kriging: */
#include "./kriging/krigingobjects.h"

/*diverse: */
#include "./Hook.h"
#include "./DofIndexing.h"
#include "./IoModel.h"
#include "./Patch.h"
#include "./Update.h"
#include "./FemModel.h"
#include "./OptArgs.h"
#include "./OptPars.h"
#include "./AdolcEdf.h"
#include "./IssmComm.h"

#endif
