/*!\file:  EnvironmentInit.cpp
 * \brief: initialize Petsc, MPI, you name it
 */ 
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
#include "../include/include.h"
#include "../toolkits/toolkits.h"

COMM EnvironmentInit(int argc,char** argv){

	/*Initialize environments: Petsc, MPI, etc...: */
	#ifdef _HAVE_PETSC_
	int ierr=PetscInitialize(&argc,&argv,(char*)0,"");  
	if(ierr) _error_("Could not initialize Petsc");
	return MPI_COMM_WORLD;
	#else
	#ifdef _HAVE_MPI_
	MPI_Init(&argc,&argv);
	return MPI_COMM_WORLD;
	#else
	return 1; //return bogus number for comm, which does not exist anyway.
	#endif
	#endif
	

}
