md=triangle(model(),'../Exp/Square.exp',150000);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setflowequation(md,'macayeal','all');
md.cluster=generic('name',oshostname(),'np',3);

md.timestepping.time_step=1.;
md.settings.output_frequency=1;
md.timestepping.final_time=4.;

%Set up transient
smb=ones(md.mesh.numberofvertices,1)*3.6;
smb=[ smb smb*2. ];

md.surfaceforcings.mass_balance=smb;
md.surfaceforcings.mass_balance(end+1,:)=[1.5 3.];
md.transient.isthermal=0;

md=solve(md,TransientSolutionEnum());

%Fields and tolerances to track changes
field_names={'Vx1','Vy1','Vel1','Pressure1','Bed1','Surface1','Thickness1','SurfaceforcingsMassBalance1', ...
	'Vx2','Vy2','Vel2','Pressure2','Bed2','Surface2','Thickness2','SurfaceforcingsMassBalance2', ...
	'Vx3','Vy3','Vel3','Pressure3','Bed3','Surface3','Thickness3','SurfaceforcingsMassBalance3', ...
	'Vx4','Vy4','Vel4','Pressure4','Bed4','Surface4','Thickness4','SurfaceforcingsMassBalance4'};
field_tolerances={1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,...
	1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,...
	1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,...
	1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10};
field_values={...
	(md.results.TransientSolution(1).Vx),...
	(md.results.TransientSolution(1).Vy),...
	(md.results.TransientSolution(1).Vel),...
	(md.results.TransientSolution(1).Pressure),...
	(md.results.TransientSolution(1).Bed),...
	(md.results.TransientSolution(1).Surface),...
	(md.results.TransientSolution(1).Thickness),...
	(md.results.TransientSolution(1).SurfaceforcingsMassBalance),...
	(md.results.TransientSolution(2).Vx),...
	(md.results.TransientSolution(2).Vy),...
	(md.results.TransientSolution(2).Vel),...
	(md.results.TransientSolution(2).Pressure),...
	(md.results.TransientSolution(2).Bed),...
	(md.results.TransientSolution(2).Surface),...
	(md.results.TransientSolution(2).Thickness),...
	(md.results.TransientSolution(2).SurfaceforcingsMassBalance),...
	(md.results.TransientSolution(3).Vx),...
	(md.results.TransientSolution(3).Vy),...
	(md.results.TransientSolution(3).Vel),...
	(md.results.TransientSolution(3).Pressure),...
	(md.results.TransientSolution(3).Bed),...
	(md.results.TransientSolution(3).Surface),...
	(md.results.TransientSolution(3).Thickness),...
	(md.results.TransientSolution(3).SurfaceforcingsMassBalance),...
	(md.results.TransientSolution(4).Vx),...
	(md.results.TransientSolution(4).Vy),...
	(md.results.TransientSolution(4).Vel),...
	(md.results.TransientSolution(4).Pressure),...
	(md.results.TransientSolution(4).Bed),...
	(md.results.TransientSolution(4).Surface),...
	(md.results.TransientSolution(4).Thickness),...
	(md.results.TransientSolution(4).SurfaceforcingsMassBalance),...
	};
