from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Square.exp',120000.)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelf.py')
md.extrude(2,1)
md=setflowequation(md,'stokes','../Exp/SquareHalfRight.exp','fill','macayeal')
md.cluster=generic('name',oshostname(),'np',3)
md.diagnostic.viscosity_overshoot=0
md=solve(md,DiagnosticSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Vx','Vy','Vz','Vel','Pressure']
field_tolerances=[1e-09,1e-09,1e-06,1e-09,1e-09]
field_values=[\
	md.results['DiagnosticSolution'][1]['Vx'],\
	md.results['DiagnosticSolution'][1]['Vy'],\
	md.results['DiagnosticSolution'][1]['Vz'],\
	md.results['DiagnosticSolution'][1]['Vel'],\
	md.results['DiagnosticSolution'][1]['Pressure'],\
	]
