/*!\file:  binary_search.cpp
 * \brief  binary search on an integer array, that is already sorted
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>

int binary_search(int* poffset,int target,int* sorted_integers,int num_integers){ /*{{{*/

	/*output: */
	int offset;  //offset, if found
	int found=0; //found=0 if target is not found, 1 otherwise.

	/*intermediary: */
	int *beg = NULL;
	int *end = NULL;
	int *mid = NULL;

	// point to beginning and end of the array
	beg=sorted_integers;
	end=sorted_integers+num_integers;
	mid=beg+(int)(num_integers/2);

	if (*beg==target){
		found=1;
		offset=0;
	}
	else if(*(end-1)==target){
		found=1;
		offset=num_integers-1;
	}
	else{
		while((beg <= end) && (*mid != target)){
			// is the target in lower or upper half?
			if (target < *mid) {
				end = mid - 1;  //new end
				mid = beg + (end-beg)/2;  //new middle
			}
			else {
				beg = mid + 1;  //new beginning
				mid = beg + (end-beg)/2;  //new middle
			}
		}
			  
		//did we find the target?
		if (*mid == target) {
			found=1;
			offset=mid-sorted_integers;
		}
		else {
			found=0;
		}
	}

	/*Assign output pointers:*/
	*poffset=offset;
	
	/*Return result: */
	return found;
} /*}}}*/
int binary_search(int* poffset,double target,double* list,int num_doubles){ /*{{{*/

	/*output: */
	int offset = 0;
	int found  = 0; /*found =  0: not found.
							found = -1: found, and target is < first element
							found =  1: found, and target is == to value at offset 
							found =  2: found, and target is > to value at offset  and < to value at offset+1
							found =  3: found, and target is >= last value */

	/*intermediary: */
	int n0 = 0;
	int n1 = int(num_doubles/2);
	int n2 = num_doubles-1;

	if(target<list[n0]){
		found  = -1;
		offset = -1;
	}
	else if(target>=list[n2]){
		found  = 3;
		offset = n2-1;
	}
	else{
		while(!found){
			/*did we find the target?*/
			if(list[n1]<=target && list[n1+1]>target){
				found = 1;
				offset = n1;
				break;
			}
			if(target < list[n1]){
				n2 = n1;
				n1 = n0 + int((n2-n0)/2);
			}
			else{
				n0 = n1;
				n1 = n0 + int((n2-n0)/2);
			}
		}

		//did we find an exact target?
		if(list[n1]==target) found = 2;
	}

	/*Assign output pointers:*/
	*poffset=offset;
	
	/*Return result: */
	return found;
} /*}}}*/
