/*!\file:  issm.cpp
 * \brief: ISSM main program
 */ 

#include "../issm.h"
	
int main(int argc,char **argv){

	/*Print starting banner:*/
	PrintBanner();

	/*Initialize exception trapping: */
	ExceptionTrapBegin();

	/*Initialize environment (MPI, PETSC, MUMPS, etc ...)*/
	EnvironmentInit(argc,argv);
		
	/*Initialize femmodel from arguments provided command line: */
	FemModel *femmodel = new FemModel(argc,argv);

	/*Solve: */
	femmodel->Solve();

	/*Output results: */
	femmodel->OutputResults();
	
	/*Wrap up: */
	delete femmodel;

	/*Finalize environment:*/
	EnvironmentFinalize();

	/*Finalize exception trapping: */
	ExceptionTrapEnd();

	/*Return unix success: */
	return 0; 
}
