/*!\file Profiler.h
 * \brief: header file for node object
 */

#ifndef _PROFILER_H_
#define _PROFILER_H_

/*Headers:*/
/*{{{*/
#include "./Object.h"
#include "../../shared/shared.h"
/*}}}*/

class DataSet;
class Parameters;

enum ProfilerEnums {
	Start,
	StartInit,
	FinishInit,
	StartCore,
	FinishCore,
	Finish
};


class Profiler: public Object{

	public: 
		Parameters*  time;
		Parameters*  flops;
		Parameters*  memory;

		/*Profiler constructors, destructors {{{*/
		Profiler();
		~Profiler();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void    Echo();
		void    DeepEcho();
		int     Id();
		int     ObjectEnum();
		Object *copy()        {_error_("Not implemented yet"); };
		/*}}}*/
		/*Profiler routines {{{*/
		void    Tag(int tagenum,bool dontmpisync=false);
		IssmDouble  Memory(int tag);
		IssmDouble  DeltaTime(int inittag, int finaltag);
		IssmDouble  DeltaFlops(int inittag, int finaltag);
		int     DeltaTimeModHour(int inittag, int finaltag);
		int     DeltaTimeModMin(int inittag, int finaltag);
		int     DeltaTimeModSec(int inittag, int finaltag);
		/*}}}*/
};

#endif  /* _PROFILER_H_ */
