/*!\file:  EnvironmentInit.cpp
 * \brief: initialize Petsc, MPI, you name it
 */ 
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif


void EnvironmentInit(int argc,char** argv){

	/*Initialize environments: Petsc, MPI, etc...: */
	#ifdef _HAVE_PETSC_
	ierr=PetscInitialize(&argc,&argv,(char*)0,"");  
	if(ierr) _error_("Could not initialize Petsc");
	#else
	#ifdef _HAVE_MPI_
	MPI_Init(&argc,&argv);
	#endif
	#endif
	
	/*Size and rank: */
	#ifdef _HAVE_MPI_
	MPI_Comm_rank(MPI_COMM_WORLD,&my_rank);  
	MPI_Comm_size(MPI_COMM_WORLD,&num_procs); 
	#endif
}
