%DEPENDENT class definition
%
%   Usage:
%      dependent=dependent();

classdef dependent
	properties (SetAccess=public) 
		name                 = '';
		type                 = '';
		fos_reverse_index    = NaN;
		exp                  = '';
		segments             = [];
		index                = -1;
		nods                 = 0;
	end
	methods
		 function obj= dependent(varargin) % {{{
			 
			 %use provided options to change fields
			 options=pairoptions(varargin{:});
				
			 obj.name=getfieldvalue(options,'name','');
			 obj.type=getfieldvalue(options,'type','');
			 obj.exp=getfieldvalue(options,'exp','');
			 obj.segments=getfieldvalue(options,'segments',[]);
			 obj.index=getfieldvalue(options,'index',-1);
			 obj.nods=getfieldvalue(options,'nods',0);

			 %if name is mass flux: 
			 if strcmpi(obj.name,'MassFlux'),
				 %make sure that we supplied a file and that it exists! 
				 if exist(obj.exp)~=2,
					 error('dependent checkconsistency: specified ''exp'' file does not exist!');
				 end
				 %process the file and retrieve segments
				 mesh=getfieldvalue(options,'mesh');
				 obj.segments=MeshProfileIntersection(mesh.elements,mesh.x,mesh.y,obj.exp);
			 end
		 end
		 %}}}
		function obj = setdefaultparameters(obj) % {{{
		%do nothing
		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{
			%do nothing for now
			if strcmpi(obj.name,'MassFlux'),
				if isempty(obj.segments),
					error('dependent checkconsistency error: need segments to compute this dependent response');
				end
				if obj.index<=0,
					error('dependent checkconsistency error: index for segments should be >=1');
				end
			end
			if ~isnan(obj.fos_reverse_index),
				if ~strcmpi(driver,'fos_reverse'),
					error('cannot declare a dependent with a fos_reverse_index when the driver is not fos_reverse!');
				end
				if obj.nods==0,
					error('ependent checkconsistency error: nods should be set to the size of the independent variable');
				end

			end

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   dependent variable :'));

			fielddisplay(obj,'name','variable name (must match corresponding Enum)');
			fielddisplay(obj,'type','type of variable (''vertex'' or ''scalar'')');
			
			if ~isnan(obj.fos_reverse_index),
				fielddisplay(obj,'fos_reverse_index','index for fos_reverse driver of ADOLC');
			end
			if ~isempty(obj.exp),
				fielddisplay(obj,'exp','file needed to compute dependent variable');
				fielddisplay(obj,'segments','mass flux segments');
			end

		end % }}}
		function scalar=typetoscalar(obj) % {{{
		if strcmpi(obj.type,'scalar'),
			scalar=0;
		elseif strcmpi(obj.type,'vertex'),
			scalar=1;
		end

		end % }}}
	end
end
