function md=diagnostic(md)
%DIAGNOSTIC - diagnostic solution sequence
%
%   Usage:
%      md=diagnostic(md)

	%timing
	t1=clock;

	%Build all models requested for diagnostic simulation
	%remark, partitions are all identical.
	md.analysis_type='diagnostic_horiz'; m_dh=CreateFemModel(md);

	if strcmpi(md.type,'3d'),
		md.analysis_type='diagnostic_vert'; m_dv=CreateFemModel(md);
	end

	% figure out number of dof: just for information purposes.
	md.dof=m_dh.nodesets.fsize; %biggest dof number

	%Get horizontal solution. 
	disp(sprintf('\n%s',['computing horizontal velocities...']));

	%plug existing velocity in inputs
	if ~isnan(md.vx) & ~isnan(md.vy),
		indx=m_dh.part(1:2:end);
		indy=m_dh.part(2:2:end);
		velocity=zeros(m_dh.nodesets.gsize,1);
		velocity(indx)=md.vx/md.yts;
		velocity(indy)=md.vy/md.yts;
		inputs=struct('velocity',velocity);
	else
		inputs={};
	end

	u_g=diagnostic_core_nonlinear(m_dh,inputs);

	if strcmpi(md.type,'3d'),
	
		%extrude velocities for collapsed penta elements
		disp(sprintf('\n%s',['extruding horizontal velocities...']));
		u_g=VelocityExtrude(m_dh.elements,m_dh.nodes,m_dh.loads,m_dh.materials,u_g);

		disp(sprintf('\n%s',['computing vertical velocities...']));
		u_g_vert=diagnostic_core_linear(m_dv,struct('velocity',u_g));

		%load results onto model: 
		md.vx=u_g(1:2:end)*md.yts;
		md.vy=u_g(2:2:end)*md.yts;
		md.vz=u_g_vert*md.yts;
		md.vel=sqrt(md.vx.^2+md.vy.^2+md.vz.^2);
		
		%Computation of pressure with Pattyn's assumptions (P=rho_ice*g*(s-z) in Pa)
		md.pressure=md.rho_ice*md.g*(md.surface-md.z);
	else
		%load results onto model
		md.vx=u_g(1:2:end)*md.yts;
		md.vy=u_g(2:2:end)*md.yts;
		md.vz=zeros(md.numberofgrids,1);
		md.vel=sqrt(md.vx.^2+md.vy.^2+md.vz.^2);
	
		%Computation of pressure with Pattyn's assumptions (P=rho_ice*g*(s-z) in Pa)
		md.pressure=md.rho_ice*md.g*(md.thickness);
	end		

	%timing
	t2=clock;
	disp(sprintf('\n%s\n',['   solution converged in ' num2str(etime(t2,t1)) ' seconds']));
