#module imports
from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class autodiff(object):
	"""
	AUTODIFF class definition

	   Usage:
	      autodiff=autodiff();
	"""

	#properties
	def __init__(self):
		# {{{ Properties
		self.isautodiff = False

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self):
		# {{{ Display
		string='   automatic differentiation parameters:'
		string="%s\n%s"%(string,fielddisplay(self,'isautodiff','indicates if the automatic differentiation is activated'))
		return string
		#}}}
	def setdefaultparameters(self):
		# {{{setdefaultparameters
		return self
	#}}}

	def checkconsistency(self,md,solution,analyses):    # {{{
		return md
	# }}}

	def marshall(self,fid):    # {{{
		WriteData(fid,'object',self,'fieldname','isautodiff','format','Boolean')
		WriteData(fid,'data',False,'enum',AutodiffMassFluxSegmentsPresentEnum(),'format','Boolean');
	# }}}

