function segments=findsegments(md)
%FINDSEGMENTS - build segments model field
%
%   Usage:
%      segments=findsegments(md);

%Now, build the connectivity tables for this mesh.
md.nodeconnectivity=NodeConnectivity(md.elements,md.numberofgrids);
md.elementconnectivity=ElementConnectivity(md.elements,md.nodeconnectivity);

%Recreate the segments
elementconnectivity=md.elementconnectivity;
elementonboundary=double(elementconnectivity(:,end)==0);
pos=find(elementonboundary);
num_segments=length(pos);
segments=zeros(num_segments,3);
for i=1:num_segments,
	el1=pos(i);
	els2=elementconnectivity(el1,find(elementconnectivity(el1,:)));
	flag=intersect(md.elements(els2(1),:),md.elements(els2(2),:));
	nods1=md.elements(el1,:);
	nods1(find(nods1==flag))=[];
	segments(i,:)=[nods1 el1];

	ord1=find(nods1(1)==md.elements(el1,:));
	ord2=find(nods1(2)==md.elements(el1,:));

	%swap segment grids if necessary
	if ( (ord1==1 & ord2==2) | (ord1==2 & ord2==3) | (ord1==3 & ord2==1) ),
		temp=segments(i,1);
		segments(i,1)=segments(i,2);
		segments(i,2)=temp;
	end
	segments(i,1:2)=fliplr(segments(i,1:2));
end
