/*!\file AutodiffDriversx
 * \brief: compute outputs from the AD mode,  using our dependents and independents, and drivers available in Adolc.
 */
#include <set>
#include "../../modules/modules.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/Numerics/adolc_edf.h"


void AutodiffDriversx(Elements* elements,Nodes* nodes,Vertices* vertices,Loads* loads,Materials* materials,Parameters* parameters,Results* results){


	int         i;
	int         dummy;
	bool        isautodiff         = false;
	int         num_dependents;
	int         num_independents;
	IssmDouble *axp                = NULL;
	double     *xp                 = NULL;
	int         anIndepIndex;
	unsigned int * indepIndices    = NULL;
	int         tangentDirNum = 2;  // <----------- set this via config

	
	/*AD mode on?: */
	parameters->FindParam(&isautodiff,AutodiffIsautodiffEnum);

	if(isautodiff){

		#ifdef _HAVE_ADOLC_

			parameters->FindParam(&num_dependents,AutodiffNumDependentsEnum);
			parameters->FindParam(&num_independents,AutodiffNumIndependentsEnum);

			if(!(num_dependents*num_independents)) return;

			if (tangentDirNum<1 || tangentDirNum>num_independents) {
			  _error_("tangentDirNum should be in [1,num_independents]"); // <------------ fix this error message to relate to config
			}

			/*retrieve state variable: */
			parameters->FindParam(&axp,&dummy,AutodiffXpEnum);

			/* driver argument */
			xp=xNew<double>(num_independents);
			for(i=0;i<num_independents;i++){
				xp[i]=reCast<double,IssmDouble>(axp[i]);
			}

			/*get the EDF pointer:*/
			ext_diff_fct *anEDF_for_solverx_p=dynamic_cast<GenericParam<Adolc_edf> * >(parameters->FindParamObject(AdolcParamEnum))->GetParameterValue().myEDF_for_solverx_p;

			/*set the forward method function pointers: */
			anEDF_for_solverx_p->zos_forward=EDF_for_solverx;
			anEDF_for_solverx_p->fos_forward=EDF_fos_forward_for_solverx;
			anEDF_for_solverx_p->fov_forward=EDF_fov_forward_for_solverx;
			anEDF_for_solverx_p->fos_reverse=EDF_fos_reverse_for_solverx;
			// anEDF_for_solverx_p->fov_reverse=EDF_fov_reverse_for_solverx;
			
			/*allocate the space for the parameters to invoke the forward methods:*/
			anEDF_for_solverx_p->dp_x=xNew<double>(anEDF_for_solverx_p->max_n);
			anEDF_for_solverx_p->dp_X=xNew<double>(anEDF_for_solverx_p->max_n);
			anEDF_for_solverx_p->dpp_X=xNew<double>(anEDF_for_solverx_p->max_n, tangentDirNum);
			anEDF_for_solverx_p->dp_y=xNew<double>(anEDF_for_solverx_p->max_m);
			anEDF_for_solverx_p->dp_Y=xNew<double>(anEDF_for_solverx_p->max_m);
			anEDF_for_solverx_p->dpp_Y=xNew<double>(anEDF_for_solverx_p->max_m, tangentDirNum);
			/*allocate the space for the parameters to invoke the reverse methods:*/
			anEDF_for_solverx_p->dp_U=xNew<double>(anEDF_for_solverx_p->max_m);
			anEDF_for_solverx_p->dpp_U=xNew<double>(num_dependents,anEDF_for_solverx_p->max_m);
			anEDF_for_solverx_p->dp_Z=xNew<double>(anEDF_for_solverx_p->max_n);
			anEDF_for_solverx_p->dpp_Z=xNew<double>(num_dependents,anEDF_for_solverx_p->max_n);

			/* Call AD driver:*/
			if (tangentDirNum==1) {
			  // single direction:
			  double *tangentDir=xNewZeroInit<double>(num_independents);
			  parameters->FindParam(&anIndepIndex,AutodiffFosForwardIndexEnum);
			  tangentDir[anIndepIndex]=1.0;
			  double *jacTimesTangentDir=xNew<double>(num_dependents);
			  double *theOutput=xNew<double>(num_dependents);
			  if (fos_forward(1,num_dependents,num_independents, 0, xp, tangentDir, theOutput, jacTimesTangentDir ))
			    _error_("fos_forward returned non-zero error code");
			  results->AddObject(new GenericExternalResult<IssmPDouble*>(results->Size()+1,AutodiffJacobianEnum,jacTimesTangentDir,num_dependents,1,1,0.0));
                          xDelete(theOutput);
                          xDelete(jacTimesTangentDir);
                          xDelete(tangentDir);
			}
			else {
			  // full Jacobian or Jacobian projection:
			  double **jacTimesSeed=xNew<double>(num_dependents,tangentDirNum);
			  if (tangentDirNum<num_independents) {
			    double **seed=xNewZeroInit<double>(num_independents,tangentDirNum);

			    // <<<<<<< from here <<<<<<<<<<<<
			    unsigned int * indepIndices=xNew<unsigned int>(tangentDirNum);
			    for(int i =0; i< tangentDirNum;++i) {
			      indepIndices[i]=i;
			    }
			    // <<<<<<<< to here << get this vector of independent indices from the config - should be 0 based and ideally also unsigned

			    // collect indices in a set to prevent accidental duplicates as long as we don't do compression:
			    std::set<unsigned int> anIndexSet;
			    for (int i=0; i<tangentDirNum; ++i) {
			      // make sure the index is in range
			      if (indepIndices[i]>num_independents) {
			        _error_("indepIndices values must be in [0,num_independents-1]");
			      }
			      if (anIndexSet.find(indepIndices[i])!=anIndexSet.end()) {
			        _error_("duplicate indepIndices values are not allowed until we implement Jacobian decompression");
			      }
			      anIndexSet.insert(indepIndices[i]);
	                      // now populate the seed matrix from the set of independent indices;
			      // simple setup with a single 1.0 per column and at most a single 1.0 per row
			      seed[indepIndices[i]][i]=1.0;
			    }
			    double *theOutput=xNew<double>(num_dependents);
			    if (fov_forward(1,num_dependents,num_independents, tangentDirNum, xp, seed, theOutput, jacTimesSeed )) {
			      _error_("fov_forward returned non-zero error code");
			    }
			    xDelete(theOutput);
			    xDelete(indepIndices);
			    xDelete(seed);
			  }
			  else {
			    if (jacobian(1,num_dependents,num_independents,xp,jacTimesSeed)) {
	                        _error_("jacobian returned non-zero error code");
			    }
			  }
			  results->AddObject(new GenericExternalResult<IssmPDouble*>(results->Size()+1,AutodiffJacobianEnum,*jacTimesSeed,num_dependents*tangentDirNum,1,1,0.0));
			  xDelete(jacTimesSeed);
			}

			/* delete the allocated space for the parameters:*/
			xDelete(anEDF_for_solverx_p->dp_x);
			xDelete(anEDF_for_solverx_p->dp_X);
			xDelete(anEDF_for_solverx_p->dpp_X);
			xDelete(anEDF_for_solverx_p->dp_y);
			xDelete(anEDF_for_solverx_p->dp_Y);
			xDelete(anEDF_for_solverx_p->dpp_Y);
			xDelete(anEDF_for_solverx_p->dp_U);
			xDelete(anEDF_for_solverx_p->dpp_U);
			xDelete(anEDF_for_solverx_p->dp_Z);
			xDelete(anEDF_for_solverx_p->dpp_Z);

			/*Free ressources: */
			xDelete(xp);
			xDelete(axp); 

		#else
			_error_("Should not be requesting AD drivers when an AD library is not available!");
		#endif
	}
}
