from math import isnan
import numpy as npy

def processdata(md,data,options):
	"""
	PROCESSDATA - process data to be plotted

		datatype = 1 -> elements
		datatype = 2 -> nodes
		datatype = 3 -> node quivers
		datatype = 4 -> patch

		Usage:
			data,datatype=processdata(md,data,options);

		See also: PLOTMODEL, PROCESSMESH
	"""

	#check format
	if (len(data)==0 or (len(data)==1 and not isinstance(data,dict) and isnan(data).all())):
		raise ValueError("processdata error message: 'data' provided is empty")

	#needed later on
	if md.mesh.numberofvertices2d:
		numberofvertices2d=md.mesh.numberofvertices2d
		numberofelements2d=md.mesh.numberofelements2d
	else:
		numberofvertices2d=npy.nan
		numberofelements2d=npy.nan

	#process patch

	#initialize datatype
	datatype=0

	#get datasize
	if npy.ndim(data)==1:
		datasize=npy.array([len(data),1])
	else:
		datasize=shape(data)
	
	#process NaN's if any
	if options.exist('nan'):
		data[npy.isnan(data)]=options.getfieldvalue('nan',0)

	#non-patch processing 

	#element data
	if datasize[0]==md.mesh.numberofelements and datasize[1]==1:
		
		#initialize datatype if non patch
		if datatype!=4 and datatype!=5:
			datatype=1

		#mask?

		#log?

	#node data
	if datasize[0]==md.mesh.numberofvertices and datasize[1]==1:
		datatype=2

		#mask?

		#log?

	#layer projection?

	#control arrow density if quiver plot

	#if datatype is still zero, error out
	if datatype==0:
		raise ValueError("processdata error: data provided not recognized or not supported")
	else:
		return data, datatype
