%test the anisotropic mesh adaptation

%create square mesh
L=1; %in m
nx=70; %numberof nodes in x direction
ny=70;
md=model;
md=squaremesh(md,L,L,nx,ny);
md.gridonboundary=zeros(md.numberofgrids,1);
md.gridonboundary(find((md.x==0 & md.y==0) | (md.x==0 & md.y==L) | (md.x==L & md.y==0) | (md.x==L & md.y==L)));

%mesh adaptation loop
plotmodel(md,'data','mesh');pause(0.5);
for i=1:1
	u=4*md.x-2; v=4*md.y-2;
	md.vel_obs=tanh(30*(u.^2+v.^2-0.25)) ...
		+tanh(30*((u-0.75).^2+(v-0.75).^2-0.25)) +tanh(30*((u-0.75).^2+(v+0.75).^2-0.25)) ...
		+tanh(30*((u+0.75).^2+(v-0.75).^2-0.25)) +tanh(30*((u+0.75).^2+(v+0.75).^2-0.25)) ;
	md=YamsCall(md,md.vel_obs,0.005,0.3,1.3,10^-4);
	md.gridonboundary=zeros(md.numberofgrids,1);
	md.gridonboundary(find((md.x==0 & md.y==0) | (md.x==0 & md.y==L) | (md.x==L & md.y==0) | (md.x==L & md.y==L)));
	plotmodel(md,'data','mesh');pause(0.5);
end
for i=1:1
	u=4*md.x-2; v=4*md.y-2;
	md.vel_obs=tanh(30*(u.^2+v.^2-0.25)) ...
		+tanh(30*((u-0.75).^2+(v-0.75).^2-0.25)) +tanh(30*((u-0.75).^2+(v+0.75).^2-0.25)) ...
		+tanh(30*((u+0.75).^2+(v-0.75).^2-0.25)) +tanh(30*((u+0.75).^2+(v+0.75).^2-0.25)) ;
	md=YamsCall(md,md.vel_obs,0.005,0.3,2,10^-4);
	md.gridonboundary=zeros(md.numberofgrids,1);
	md.gridonboundary(find((md.x==0 & md.y==0) | (md.x==0 & md.y==L) | (md.x==L & md.y==0) | (md.x==L & md.y==L)));
	plotmodel(md,'data','mesh');pause(0.5);
end
for i=1:3,
	u=4*md.x-2; v=4*md.y-2;
	md.vel_obs=tanh(30*(u.^2+v.^2-0.25)) ...
		+tanh(30*((u-0.75).^2+(v-0.75).^2-0.25)) +tanh(30*((u-0.75).^2+(v+0.75).^2-0.25)) ...
		+tanh(30*((u+0.75).^2+(v-0.75).^2-0.25)) +tanh(30*((u+0.75).^2+(v+0.75).^2-0.25)) ;
	md=YamsCall(md,md.vel_obs,0.005,0.3,2,0.001);
	md.gridonboundary=zeros(md.numberofgrids,1);
	md.gridonboundary(find((md.x==0 & md.y==0) | (md.x==0 & md.y==L) | (md.x==L & md.y==0) | (md.x==L & md.y==L)));
	plotmodel(md,'data','mesh');pause(0.5);
end
md.vel_obs=tanh(30*((4*md.x-2).^2+(4*md.y-2).^2-0.25))+...
	tanh(30*((4*md.x-2.75).^2+(4*md.y-1.25).^2-2.75))+...
	tanh(30*((4*md.x-2.75).^2+(4*md.y-2).^2-1.25))+...
	tanh(30*((4*md.x-1.25).^2+(4*md.y-2).^2-2.75))+...
	tanh(30*((4*md.x-1.25).^2+(4*md.y-2).^2-1.25));
