md=triangle(model,'../Exp/Square.exp',50000);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md=setflowequation(md,'macayeal','all');
md.cluster=generic('name',oshostname(),'np',3);
md.diagnostic.requested_outputs=StressTensorEnum;
md.autodiff.isautodiff=true;
md.verbose=verbose('autodiff',true);

md.autodiff.independents={...
	independent('name','Thickness','type','vertex','nods',md.mesh.numberofvertices,'fos_forward_index',1), ...
	independent('name','Surface','type','vertex','nods',md.mesh.numberofvertices)...
	};

md.autodiff.dependents={...
	dependent('name','IceVolume','type','scalar')...
	};
md.autodiff.driver='fos_forward';

md=solve(md,PrognosticSolutionEnum);
%md=solve(md,TransientSolutionEnum);
