%INDEPENDENT class definition
%
%   Usage:
%      independent=independent();

classdef independent
	properties (SetAccess=public) 
		name                 = '';
		type                 = '';
		fos_forward_index    = NaN;
		nods                 = 0;
	end
	methods
		 function obj= independent(varargin) % {{{
			 
			 %use provided options to change fields
			 options=pairoptions(varargin{:});

			 %OK get other fields
			 obj=AssignObjectFields(pairoptions(varargin{:}),obj);

		 end
		 %}}}
		function obj = setdefaultparameters(obj) % {{{
			%do nothing

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{
			%do nothing for now
			if ~isnan(obj.fos_forward_index),
				if obj.nods==0,
					error('independent checkconsistency error: nods should be set to the size of the independent variable');
				end
			end

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   independent variable :'));

			fielddisplay(obj,'name','variable name (must match corresponding Enum)');
			fielddisplay(obj,'type','type of variable (''vertex'' or ''scalar'')');
			if ~isnan(obj.fos_forward_index),
				fielddisplay(obj,'fos_forward_index','index for fos_foward driver of ADOLC');
			end

		end % }}}
		function scalar=typetoscalar(obj) % {{{
			if strcmpi(obj.type,'scalar'),
				scalar=0;
			elseif strcmpi(obj.type,'vertex'),
				scalar=1;
			end
		end % }}}
	end
end
