%AUTODIFF class definition
%
%   Usage:
%      autodiff=autodiff();

classdef autodiff
	properties (SetAccess=public) 
		isautodiff   = false;
		dependents   = {};
		independents = {};
		driver       = 'fos_forward';
	end
	methods
		function obj = autodiff(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			%Early return 
			if ~obj.isautodiff, return; end

			%Driver value:
			md = checkfield(md,'autodiff.driver','values',{'fos_forward'});

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   automatic differentiation parameters:'));
			fielddisplay(obj,'isautodiff','indicates if the automatic differentiation is activated');
			fielddisplay(obj,'dependents','list of dependent variables');
			fielddisplay(obj,'independents','list of independent variables');
			fielddisplay(obj,'driver','ADOLC driver');
		end % }}}
		function marshall(obj,fid) % {{{

			WriteData(fid,'object',obj,'fieldname','isautodiff','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','driver','format','String');
			
			%early return
			if ~obj.isautodiff, return; end

			%process dependent variables
			num_dependent_objects=numel(obj.dependents);
			WriteData(fid,'data',num_dependent_objects,'enum',AutodiffNumDependentObjectsEnum(),'format','Integer');

			if(num_dependent_objects),
				names=zeros(num_dependent_objects,1);
				types=zeros(num_dependent_objects,1);

				for i=1:num_dependent_objects,
					dep=obj.dependents{i};

					names(i)=StringToEnum(dep.name);
					types(i)=dep.typetoscalar();
				end
				WriteData(fid,'data',names,'enum',AutodiffDependentObjectNamesEnum(),'format','IntMat','mattype',3);
				WriteData(fid,'data',types,'enum',AutodiffDependentObjectTypesEnum(),'format','IntMat','mattype',3);
			end
			
			
			%process independent variables
			num_independent_objects=numel(obj.independents);
			WriteData(fid,'data',num_independent_objects,'enum',AutodiffNumIndependentObjectsEnum(),'format','Integer');

			if(num_independent_objects),
				names=zeros(num_independent_objects,1);
				types=zeros(num_independent_objects,1);

				for i=1:num_independent_objects,
					indep=obj.independents{i};

					names(i)=StringToEnum(indep.name);
					types(i)=indep.typetoscalar();
				end
				WriteData(fid,'data',names,'enum',AutodiffIndependentObjectNamesEnum(),'format','IntMat','mattype',3);
				WriteData(fid,'data',types,'enum',AutodiffIndependentObjectTypesEnum(),'format','IntMat','mattype',3);
			end

			%if driver is fos_forward, build index: 
			if strcmpi(obj.driver,'fos_forward'),
				index=0;
				
				for i=1:num_independent_objects,
					indep=obj.independents{i};
					if ~isnan(indep.fos_forward_index),
						index=index+indep.fos_forward_index;
						break;
					else
						if strcmpi(indep.type,'scalar'),
							index=index+1;
						else
							index=index+indep.nods;
						end
					end
				end
				WriteData(fid,'data',index-1,'enum',AutodiffFosForwardIndexEnum(),'format','Integer'); %c-index numbering.
			end
		end % }}}
	end
end
