from matplotlib.font_manager import FontProperties
import pylab as p

def applyoptions(md,data,options):
	'''
	APPLYOPTIONS - apply options to current plot

		Usage:
			applyoptions(md,data,options)

		See also: PLOTMODEL, PARSE_OPTIONS
	'''

	#some defaults (this seems to be adding a field that already exists...)
	#if not isnan(md.mesh.hemisphere):
	#	options.addfielddefault('hemisphere',md.mesh.hemisphere)

	#font
	fontsize=options.getfieldvalue('fontsize',14)
	fontweight=options.getfieldvalue('fontweight','normal')
	fontfamily=options.getfieldvalue('fontfamily','sans-serif')
	font={
			'fontsize'		:fontsize,
			'fontweight'	:fontweight,
			'family'			:fontfamily
			}

	#title
	if options.exist('title'):
		title=options.getfieldvalue('title')
		if options.exist('titlefontsize'):
			titlefontsize=options.getfieldvalue('titlefontsize')
		else:
			titlefontsize=fontsize
		if options.exist('titlefontweight'):
			titlefontweight=options.getfieldvalue('titlefontweight')
		else:
			titlefontweight=fontweight
		#title font
		titlefont=font.copy()
		titlefont['size']=titlefontsize
		titlefont['weight']=titlefontweight
		p.title(title,**titlefont)
		
	#xlabel, ylabel, zlabel
	if options.exist('labelfontsize'):
		labelfontsize=options.getfieldvalue('labelfontsize')
	else:
		labelfontsize=fontsize
	if options.exist('labelfontweight'):
		labelfontweight=options.getfieldvalue('labelfontweight')
	else:
		labelfontweight=fontweight

	#font dict for labels
	labelfont=font.copy()
	labelfont['fontsize']=labelfontsize
	labelfont['fontweight']=labelfontweight

	if options.exist('xlabel'):
		p.xlabel(options.getfieldvalue('xlabel'),**labelfont)
	if options.exist('ylabel'):
		p.ylabel(options.getfieldvalue('ylabel'),**labelfont)
	if options.exist('zlabel'):
		p.zlabel(options.getfieldvalue('zlabel'),**labelfont)

	#xticks, yticks, zticks

	#view

	#axis

	#box

	#xlim, ylim, zlim
	if options.exist('xlim'):
		p.xlim(options.getfieldvalue('xlim'))
	if options.exist('ylim'):
		p.xlim(options.getfieldvalue('ylim'))
	if options.exist('zlim'):
		p.xlim(options.getfieldvalue('zlim'))

	#latlon

	#Basinzoom

	#ShowBasins

	#Caxis

	#shading

	#grid
	if options.exist('grid'):
		p.grid()

	#colormap

	#wrapping

	#colorbar

	#area

	#expdisp

	#text

	#north arrow

	#scale ruler

	#streamlines

	#contours

	#YTickLabel

	#XTickLabel

	#xtick

	#ytick

	#axis positions

	#figure position

	#axes position

	#showregion

	#flat edges of a partition

	#scatter

	#backgroundcolor

	#figurebackgroundcolor

	#lighting

	#point cloud

	#inset
