/*!\file Contour.h
 * \brief: header file for Contour object
 */

#ifndef _CONTOUR_H_
#define _CONTOUR_H_

/*Headers:*/
/*{{{*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../shared/Alloc/xNewDelete.h"
#include "../../shared/MemOps/xMemCpy.h"
#include "../../io/io.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "./Object.h"
/*}}}*/

template <class doubletype>
class Contour: public Object{

	public: 

		int         id;
		int         nods;     //number of vertices in the contour
		doubletype *x;
		doubletype *y;
		bool        closed;   //is this contour closed?

		/*Contour constructors, destructors :*/
		/*FUNCTION Contour() {{{*/
		Contour(){
			this->id     = 0;
			this->nods   = 0;
			this->x      = NULL;
			this->y      = NULL;
			this->closed = false;
		}
		/*}}}*/
		/*FUNCTION Contour(int pid, int nods, doubletype* x, doubletype* y,bool closed) {{{*/
		Contour(int pid,int pnods, doubletype* px, doubletype* py,bool pclosed){

			this->id     = pid;
			this->nods   = pnods;
			this->closed = pclosed;
			if(nods){
				this->x=xNew<doubletype>(nods);
				xMemCpy<doubletype>(this->x,px,nods);
				this->y=xNew<doubletype>(nods);
				xMemCpy<doubletype>(this->y,py,nods);
			}
		}
		/*}}}*/
		/*FUNCTION ~Contour() {{{*/
		~Contour(){
			xDelete<doubletype>(this->x);
			xDelete<doubletype>(this->y);
		}
		/*}}}*/

		/*Object virtual function resolutoin: */
		/*FUNCTION Echo(){{{*/
		void Echo(void){
			_printLine_(" Contour: " << id);
			_printLine_("    nods: " << nods);
			_printLine_("  closed: " << (closed?"true":"false"));
			if(nods){
				_printLine_("   x , y:");
				for(int i=0;i<nods;i++){
					_printLine_(i << ": " << x[i] << " | " << y[i]);
				}
			}
		}
		/*}}}*/
		/*FUNCTION DeepEcho(){{{*/
		void DeepEcho(void){
			this->Echo();
		}
		/*}}}*/
		/*FUNCTION Id(){{{*/
		int Id(void){
			return id;
		}
		/*}}}*/
		/*FUNCTION MyRank{{{*/
		int MyRank(void){ 
			extern int my_rank;
			return my_rank; 
		}
		/*}}}*/
		/*FUNCTION ObjectEnum{{{*/
		int ObjectEnum(void){
			return ContourEnum;
		}
		/*}}}*/
		/*FUNCTION copy {{{*/
		Object* copy() {
			return new Contour(*this); 
		}
		/*}}}*/
};

#endif  /* _CONTOUR_H_ */
