function outoptions=process_mesh_options(options)
%DEFAULT_MESH_OPTIONS - set up default options for mesh phase
%
%   Usage:
%      options=process_mesh_options(options)
%
%   See also: MESH,MESHYAMS,RECOVER_OPTIONS

%domainoutline: check on this option, error out otherwise
found=0;
for i=1:size(options,1),
	if strcmpi(options{i,1},'domainoutline'),
		if exist(options{i,2}),
			domainoutline=options{i,2};
			found=1;
		else
			error(['process_mesh_options error message: domain outline file ' options{i,2} ' not found!']);
		end
	end
end
if ~found,
	error('process_mesh_options error message: no ''domainoutline'' was provided');
end

%velocities: check on this option, error out otherwise
found=0;
for i=1:size(options,1),
	if strcmpi(options{i,1},'velocities'),
		if exist(options{i,2}),
			velocities=options{i,2};
			found=1;
		else
			error(['process_mesh_options error message: velocities file ' options{i,2} ' not found!']);
		end
	end
end
if ~found,
	error('process_mesh_options error message: no ''velocities'' was provided');
end

%groundeddomain: check on this option, error out otherwise
found=0;
for i=1:size(options,1),
	if strcmpi(options{i,1},'groundeddomain'),
		if exist(options{i,2}),
			groundeddomain=options{i,2};
			found=1;
		else
			error(['process_mesh_options error message: grounded domain file ' options{i,2} ' not found!']);
		end
	end
end
if ~found,
	groundeddomain='N/A';
end

%nsteps
found=0;
for i=1:size(options,1),
	if strcmpi(options{i,1},'nsteps'),
		nsteps=options{i,2};
		found=1;
	end
end
if ~found, nsteps=6;end

%resolution
found=0;
for i=1:size(options,1),
	if strcmpi(options{i,1},'resolution'),
		resolution=options{i,2};
		found=1;
	end
end
if ~found, resolution=5000;end

%hmin
found=0;
for i=1:size(options,1),
	if strcmpi(options{i,1},'hmin'),
		hmin=options{i,2};
		found=1;
	end
end
if ~found, hmin=300;end

%hmax
found=0;
for i=1:size(options,1),
	if strcmpi(options{i,1},'hmax'),
		hmax=options{i,2};
		found=1;
	end
end
if ~found, hmax=150*10^3;end

%epsilon
found=0;
for i=1:size(options,1),
	if strcmpi(options{i,1},'epsilon'),
		epsilon=options{i,2};
		found=1;
	end
end
if ~found, epsilon=3;end

%gradation
found=0;
for i=1:size(options,1),
	if strcmpi(options{i,1},'gradation'),
		gradation=options{i,2};
		found=1;
	end
end
if ~found, 
	gradation=[1.5*ones(2,1);3*ones(nsteps,1)];
	gradation(nsteps+1:end)=[];
end

if length(gradation)~=nsteps
	error(['process_mesh_options error message: gradation should have the same length as nsteps (' num2str(nsteps) ')']);
end

%output options
outoptions=struct('domainoutline',domainoutline,'velocities',velocities,'groundeddomain',groundeddomain,'nsteps',nsteps,'resolution',resolution,'hmin',hmin,'hmax',hmax,'epsilon',epsilon,'gradation',gradation);
