/*
	InternalFront.h
*/

#ifndef _INTERNALFRONT_H
#define _INTERNALFRONT_H

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
	#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*For python modules: needs to come before header files inclusion*/
#ifdef _HAVE_PYTHON_
#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#endif

#include "../../c/include/globals.h"
#include "../../c/shared/shared.h"
#include "../../c/issm-binding.h"
#include "../../c/io/io.h"

#undef __FUNCT__ 
#define __FUNCT__  "InternalFront"

#ifdef _HAVE_MATLAB_MODULES_
/* serial input macros: */
#define MODEL prhs[0]
/* serial output macros: */
#define FRONT (mxArray**)&plhs[0]
#endif

#ifdef _HAVE_PYTHON_MODULES_
/* serial input macros: */
#define MODEL PyTuple_GetItem(args,0)
/* serial output macros: */
#define FRONT output,0]
#endif

/* serial arg counts: */
#undef NLHS
#define NLHS  1
#undef NRHS
#define NRHS  1

#endif
