/*
	HoleFiller.h
*/

#ifndef _HOLEFILLER_H
#define _HOLEFILLER_H

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
	#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*For python modules: needs to come before header files inclusion*/
#ifdef _HAVE_PYTHON_
#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#endif

#include "../../c/include/globals.h"
#include "../../c/modules/modules.h"
#include "../../c/Container/Container.h"
#include "../../c/shared/shared.h"
#include "../../c/issm-binding.h"

#undef __FUNCT__ 
#define __FUNCT__  "HoleFiller"

#ifdef _HAVE_MATLAB_MODULES_
/* serial input macros: */
#define IMAGEIN prhs[0]
#define SMOOTH  prhs[1]
/* serial output macros: */
#define IMAGEOUT (mxArray**)&plhs[0]
#endif

#ifdef _HAVE_PYTHON_MODULES_
/* serial input macros: */
#define IMAGEIN PyTuple_GetItem(args,0)
#define SMOOTH  PyTuple_GetItem(args,1)
/* serial output macros: */
#define IMAGEOUT output,0
#endif

/* serial arg counts: */
#undef NLHS
#define NLHS  1
#undef NRHS
#define NRHS  2

#endif  /* _HOLEFILLER_H */
