/*!\file: controlrestart.cpp
 * \brief: save as much as possible, to be able to restart the control_core solution
 */ 

#include "./solutions.h"
#include "../modules/modules.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void controlrestart(FemModel* femmodel,IssmDouble* J){

	int      num_controls;
	int*     control_type = NULL;
	int      nsteps;
	bool     dakota_analysis=true;

	/*retrieve output file name: */
	femmodel->parameters->FindParam(&num_controls,InversionNumControlParametersEnum);
	femmodel->parameters->FindParam(&control_type,NULL,InversionControlParametersEnum);
	femmodel->parameters->FindParam(&nsteps,InversionNstepsEnum);
	femmodel->parameters->FindParam(&dakota_analysis,QmuIsdakotaEnum);

	/*only save if we are not running qmu analysis. We certainly don't want to save control results each time we 
	 * run on control core!: */
	if(!dakota_analysis){
		/*we essentially want J and the parameter: */
		for(int i=0;i<num_controls;i++) InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,control_type[i]);
		#ifdef _HAVE_ADOLC_
		IssmPDouble* J_passive=xNew<IssmPDouble>(nsteps);
		for(int i=0;i<nsteps;i++)J_passive[i]=reCast<IssmPDouble>(J[i]);
		femmodel->results->AddObject(new GenericExternalResult<IssmPDouble*>(femmodel->results->Size()+1,JEnum,J_passive,nsteps,1,1,0));
		xDelete<IssmPDouble>(J_passive);
		#else
		femmodel->results->AddObject(new GenericExternalResult<IssmPDouble*>(femmodel->results->Size()+1,JEnum,J,nsteps,1,1,0));
		#endif
		//femmodel->results->AddObject(new GenericExternalResult<char*>(femmodel->results->Size()+1,InversionControlParametersEnum,EnumToStringx(control_type),1,0));

		/*write to disk: */
		OutputResultsx(femmodel->elements, femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters,femmodel->results);
	}

	/*Clean up and return*/
	xDelete<int>(control_type);
}
