/*!\file:  ProcessArguments.cpp
 * \brief: process arguments
 */ 

#include <stdio.h>
#include <cstring>

#include "../shared/shared.h"
#include "../include/include.h"

void ProcessArguments(int* solution_type,char** pbinfilename,char** poutbinfilename,char** ppetscfilename,char** plockfilename,char** prootpath, int argc,char **argv){

	char *modelname      = NULL;
	char *binfilename    = NULL;
	char *outbinfilename = NULL;
	char *petscfilename  = NULL;
	char *lockfilename   = NULL;
	char *rootpath       = NULL;
	char *rootpatharg    = NULL;

	*solution_type=StringToEnumx(argv[1]);
	if(argc<2)_error_("Usage error: no solution requested");
	if(argc<3)_error_("Usage error: missing execution directory");
	if(argc<4)_error_("Usage error: missing model name");

	rootpatharg=argv[2];
	if(strcmp(strstr(rootpatharg,"/"),"/")!=0){ 
		rootpath       = xNew<char>(strlen(rootpatharg)+2); sprintf(rootpath,"%s/",rootpatharg);
	}
	else{
		rootpath       = xNew<char>(strlen(rootpatharg)+1); sprintf(rootpath,"%s",rootpatharg);
	}

	modelname=argv[3];
	if(strstr(modelname,rootpath)==NULL){
		binfilename    = xNew<char>(strlen(rootpath)+strlen(modelname)+strlen(".bin")   +1); sprintf(binfilename,   "%s%s%s",rootpath,modelname,".bin");
		outbinfilename = xNew<char>(strlen(rootpath)+strlen(modelname)+strlen(".outbin")+1); sprintf(outbinfilename,"%s%s%s",rootpath,modelname,".outbin");
		petscfilename  = xNew<char>(strlen(rootpath)+strlen(modelname)+strlen(".petsc") +1); sprintf(petscfilename, "%s%s%s",rootpath,modelname,".petsc");
		lockfilename   = xNew<char>(strlen(rootpath)+strlen(modelname)+strlen(".lock")  +1); sprintf(lockfilename,  "%s%s%s",rootpath,modelname,".lock");
	}
	else{
		binfilename    = xNew<char>(strlen(modelname)+strlen(".bin")   +1); sprintf(binfilename,   "%s%s",modelname,".bin");
		outbinfilename = xNew<char>(strlen(modelname)+strlen(".outbin")+1); sprintf(outbinfilename,"%s%s",modelname,".outbin");
		petscfilename  = xNew<char>(strlen(modelname)+strlen(".petsc") +1); sprintf(petscfilename, "%s%s",modelname,".petsc");
		lockfilename   = xNew<char>(strlen(modelname)+strlen(".lock")  +1); sprintf(lockfilename,  "%s%s",modelname,".lock");
	}

	/*Clean up and assign output pointer*/
	*pbinfilename=binfilename;
	*poutbinfilename=outbinfilename;
	*ppetscfilename=petscfilename;
	*plockfilename=lockfilename;
	*prootpath=rootpath;

}
