/*!\file: CreateParametersAutodiff.cpp
 * \brief driver for creating parameters dataset, for autodiff analysis.
 */ 

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void CreateParametersAutodiff(Parameters** pparameters,IoModel* iomodel,int solution_type,int analysis_type){
	
	int         i,j;
	Parameters *parameters       = NULL;
	bool        autodiff_analysis;
	int*        dependents       = NULL;
	int         num_dependents;
	int*        independents       = NULL;
	int         num_independents;
	int         numberofvertices;
	IssmDouble* xp=NULL;
	
	/*Get parameters: */
	parameters=*pparameters;

	/*retrieve some parameters: */
	iomodel->Constant(&autodiff_analysis,AutodiffIsautodiffEnum);
	
	if(autodiff_analysis){

		iomodel->Constant(&num_independents,AutodiffNumIndependentsEnum);
		iomodel->Constant(&num_dependents,AutodiffNumDependentsEnum);
		iomodel->Constant(&numberofvertices,MeshNumberofverticesEnum);

		/*recover dependents: */
		parameters->AddObject(iomodel->CopyConstantObject(AutodiffNumDependentsEnum));
		if(num_dependents){
			iomodel->FetchData(&dependents,NULL,&num_dependents,AutodiffDependentsEnum);
			parameters->AddObject(new IntVecParam(AutodiffDependentsEnum,dependents,num_dependents));
		}

		/*recover independents: */
		parameters->AddObject(iomodel->CopyConstantObject(AutodiffNumIndependentsEnum));
		if(num_independents){
			iomodel->FetchData(&independents,NULL,&num_independents,AutodiffIndependentsEnum);
			parameters->AddObject(new IntVecParam(AutodiffIndependentsEnum,independents,num_independents));

			/*Build state vector, value at which we compute our gradients of dependent variables in adolc: the xp vector  */
			xp=xNew<IssmDouble>(num_independents*numberofvertices);
			for(i=0;i<num_independents;i++){
				IssmDouble* values=iomodel->data[independents[i]];
				for(j=0;j<numberofvertices;j++){
					xp[i*numberofvertices+j]=values[j];
				}
			}
			parameters->AddObject(new DoubleVecParam(AutodiffXpEnum,xp,num_independents*numberofvertices));
		}

		/*Assign output pointer: */
		*pparameters=parameters;
	}
}
